package org.dromara.system.controller.system;

import cn.dev33.satoken.annotation.SaIgnore;
import cn.hutool.core.util.ReflectUtil;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.dromara.common.core.domain.R;
import org.dromara.system.service.ISysLogininforService;
import org.dromara.system.service.ISysOperLogService;
import org.dromara.system.service.ISysRoleService;
import org.dromara.system.service.ISysUserService;
import org.dromara.system.service.impl.SysHmacService;
import org.dromara.system.zwy.client.HmacClient;
import org.dromara.system.zwy.domain.HmacCheckRequest;
import org.dromara.system.zwy.utils.ObjectHashGenerator;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.nio.charset.StandardCharsets;
import java.util.*;


/**
 * zj
 * 2025.6.23
 */
@Validated
@RequiredArgsConstructor
@RestController
@RequestMapping("/hmac")
@Slf4j
public class SysHmacController {

    private final SysHmacService sysHmacService;

    @SaIgnore
    @PostMapping("/verifyHmac")
    public R<Map<String, Object>> verifyHmac(@RequestBody HmacCheckRequest request) {

        return sysHmacService.verify(request);

    }


}
