package org.dromara.zjk;

import org.apache.dubbo.config.spring.context.annotation.EnableDubbo;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.context.metrics.buffering.BufferingApplicationStartup;
import org.springframework.context.annotation.EnableAspectJAutoProxy;

/**
 * ${DESCRIPTION}
 *
 * @author : yanguohua
 * @version : 1.0
 * @date : $DATE $TIME
 */
@EnableAspectJAutoProxy(proxyTargetClass = true)
@EnableDubbo
@SpringBootApplication(scanBasePackages = {
    "org.dromara.zjk",
    "org.dromara.common"
})
public class ZjkApiApplication {
    public static void main(String[] args) {
        SpringApplication application = new SpringApplication(ZjkApiApplication.class);
        application.setApplicationStartup(new BufferingApplicationStartup(2048));
        application.run(args);
        System.out.println("(♥◠‿◠)ﾉﾞ  专家库api启动成功   ლ(´ڡ`ლ)ﾞ  ");
    }
}
