package org.dromara.zjk.annualInspection.annualInspectionAudit.domain.vo;

import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import com.alibaba.excel.annotation.ExcelProperty;
import io.github.linpeilie.annotations.AutoMapper;
import lombok.Data;

import org.dromara.common.excel.annotation.ExcelDictFormat;
import org.dromara.common.excel.convert.ExcelDictConvert;
import org.dromara.zjk.zwy.annotation.EncryptSensitive;
import org.dromara.zjk.annotation.PropertyMsg;
import org.dromara.zjk.annualInspection.annualInspectionAudit.domain.ZjkAnnualInspection;

import java.io.Serial;
import java.io.Serializable;
import java.util.Date;


/**
 * 年检管理视图对象 zjk_annual_inspection
 *
 * @author zhangzhou
 * @date 2024-11-13
 */
@Data
@ExcelIgnoreUnannotated
@AutoMapper(target = ZjkAnnualInspection.class)
public class ZjkAnnualInspectionVo implements Serializable {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * id
     */
    private Long id;

    /**
     * 用户 id
     */
    private Long userId;

    /**
     * 专家 id
     */
    private Long expertId;

    @ExcelProperty(value = "专家姓名")
    private String expertName;

    @EncryptSensitive
    @ExcelProperty(value = "联系方式")
    private String contact;

    @ExcelProperty(value = "身份证号")
    @EncryptSensitive
    private String idCard;

    @ExcelProperty(value = "工作单位")
    private String workUnit;
    /**
     * 年检编号
     */
    @ExcelProperty(value = "年检编号")
    private String annualInspectionSn;

    /**
     * 年检名称
     */
    @ExcelProperty(value = "年检名称")
    private String annualInspectionName;

    /**
     * 审核方式(1 人工年检 2 自动年检)
     */
    @ExcelProperty(value = "审核方式(1 人工年检 2 自动年检)", converter = ExcelDictConvert.class)
    @ExcelDictFormat(dictType = "annual_inspection_type")
    private String annualInspectionType;

    /**
     * 年检状态(1 待年检 2 已通过 3 未通过)
     */
    @ExcelProperty(value = "年检状态(1 待年检 2 已通过 3 未通过)", converter = ExcelDictConvert.class)
    @ExcelDictFormat(dictType = "annual_inspection_status")
    private String annualInspectionStatus;

    /**
     * 审核时间
     */
    @ExcelProperty(value = "审核时间")
    private Date auditTime;

    /**
     * 审核原因
     */
    @PropertyMsg(propertyName = "审核原因")
    private String reason;

    private String hmac;
}
