package org.dromara.zjk.annualInspection.annualInspectionRecords.domain.vo;

import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import com.alibaba.excel.annotation.ExcelProperty;
import io.github.linpeilie.annotations.AutoMapper;
import lombok.Data;

import org.dromara.common.excel.annotation.ExcelDictFormat;
import org.dromara.common.excel.convert.ExcelDictConvert;
import org.dromara.zjk.zwy.annotation.EncryptSensitive;
import org.dromara.zjk.annualInspection.annualInspectionRecords.domain.ZjkAnnualInspectionRecords;

import java.io.Serial;
import java.io.Serializable;
import java.util.Date;


/**
 * 年检记录视图对象 zjk_annual_inspection_records
 *
 * @author zhangzhou
 * @date 2024-11-13
 */
@Data
@ExcelIgnoreUnannotated
@AutoMapper(target = ZjkAnnualInspectionRecords.class)
public class ZjkAnnualInspectionRecordsVo implements Serializable {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * id
     */
    @ExcelProperty(value = "id")
    private Long id;

    private Long userId;


    private Long expertId;


    @ExcelProperty(value = "专家姓名")
    private String expertName;

    @EncryptSensitive
    @ExcelProperty(value = "联系方式")
    private String contact;

    @ExcelProperty(value = "身份证号")
    @EncryptSensitive
    private String idCard;

    @ExcelProperty(value = "工作单位")
    private String workUnit;

    /**
     * 年检记录编号
     */
    @ExcelProperty(value = "年检记录编号")
    private String recordsSn;

    /**
     * 年检审核编号
     */
    @ExcelProperty(value = "年检审核编号")
    private String annualInspectionSn;

    /**
     * 年检名称
     */
    @ExcelProperty(value = "年检名称")
    private String annualInspectionName;

    /**
     * 审核方式(1 人工年检 2 自动年检)
     */
    @ExcelProperty(value = "审核方式(1 人工年检 2 自动年检)", converter = ExcelDictConvert.class)
    @ExcelDictFormat(dictType = "annual_inspection_type")
    private String auditType;

    /**
     * 年检状态(1 待年检 2 已通过 3 未通过)
     */
    @ExcelProperty(value = "年检状态(1 待年检 2 已通过 3 未通过)", converter = ExcelDictConvert.class)
    @ExcelDictFormat(dictType = "annual_inspection_status")
    private String annualInspectionStatus;

    /**
     * 审核时间
     */
    @ExcelProperty(value = "审核时间")
    private Date auditTime;


}
