package org.dromara.zjk.annualInspection.annualInspectionRecords.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import lombok.RequiredArgsConstructor;
import org.dromara.common.core.utils.MapstructUtils;
import org.dromara.common.core.utils.StringUtils;
import org.dromara.common.mybatis.core.page.PageQuery;
import org.dromara.common.mybatis.core.page.TableDataInfo;
import org.dromara.zjk.annualInspection.annualInspectionRecords.domain.ZjkAnnualInspectionRecords;
import org.dromara.zjk.annualInspection.annualInspectionRecords.domain.bo.ZjkAnnualInspectionRecordsBo;
import org.dromara.zjk.annualInspection.annualInspectionRecords.domain.vo.ZjkAnnualInspectionRecordsVo;
import org.dromara.zjk.annualInspection.annualInspectionRecords.mapper.ZjkAnnualInspectionRecordsMapper;
import org.dromara.zjk.annualInspection.annualInspectionRecords.service.IZjkAnnualInspectionRecordsService;
import org.dromara.zjk.mapper.ZjkExpertMapper;
import org.springframework.stereotype.Service;

import java.util.Collection;
import java.util.List;
import java.util.Map;

/**
 * 年检记录Service业务层处理
 *
 * @author zhangzhou
 * @date 2024-11-13
 */
@RequiredArgsConstructor
@Service
public class ZjkAnnualInspectionRecordsServiceImpl implements IZjkAnnualInspectionRecordsService {

    private final ZjkAnnualInspectionRecordsMapper baseMapper;

    private final ZjkExpertMapper expertMapper;

    /**
     * 查询年检记录
     *
     * @param id 主键
     * @return 年检记录
     */
    @Override
    public ZjkAnnualInspectionRecordsVo queryById(Long id){
        return baseMapper.selectVoById(id);
    }

    /**
     * 分页查询年检记录列表
     *
     * @param bo        查询条件
     * @param pageQuery 分页参数
     * @return 年检记录分页列表
     */
    @Override
    public TableDataInfo<ZjkAnnualInspectionRecordsVo> queryPageList(ZjkAnnualInspectionRecordsBo bo, PageQuery pageQuery) {
        Page<ZjkAnnualInspectionRecordsVo> result = baseMapper.queryAnnualInspectionRecords(pageQuery.build(), bo);
        return TableDataInfo.build(result);
    }

    /**
     * 查询符合条件的年检记录列表
     *
     * @param bo 查询条件
     * @return 年检记录列表
     */
    @Override
    public List<ZjkAnnualInspectionRecordsVo> queryList(ZjkAnnualInspectionRecordsBo bo) {
        LambdaQueryWrapper<ZjkAnnualInspectionRecords> lqw = buildQueryWrapper(bo);
        return baseMapper.selectVoList(lqw);
    }

    private LambdaQueryWrapper<ZjkAnnualInspectionRecords> buildQueryWrapper(ZjkAnnualInspectionRecordsBo bo) {
        Map<String, Object> params = bo.getParams();
        LambdaQueryWrapper<ZjkAnnualInspectionRecords> lqw = Wrappers.lambdaQuery();
        lqw.eq(bo.getUserId() != null, ZjkAnnualInspectionRecords::getUserId, bo.getUserId());
        lqw.eq(bo.getExpertId() != null, ZjkAnnualInspectionRecords::getExpertId, bo.getExpertId());
        lqw.like(StringUtils.isNotBlank(bo.getRecordsSn()), ZjkAnnualInspectionRecords::getRecordsSn, bo.getRecordsSn());
        lqw.eq(StringUtils.isNotBlank(bo.getAnnualInspectionSn()), ZjkAnnualInspectionRecords::getAnnualInspectionSn, bo.getAnnualInspectionSn());
        lqw.like(StringUtils.isNotBlank(bo.getAnnualInspectionName()), ZjkAnnualInspectionRecords::getAnnualInspectionName, bo.getAnnualInspectionName());
        lqw.eq(StringUtils.isNotBlank(bo.getAuditType()), ZjkAnnualInspectionRecords::getAuditType, bo.getAuditType());
        lqw.eq(StringUtils.isNotBlank(bo.getAnnualInspectionStatus()), ZjkAnnualInspectionRecords::getAnnualInspectionStatus, bo.getAnnualInspectionStatus());
        lqw.eq(bo.getAuditTime() != null, ZjkAnnualInspectionRecords::getAuditTime, bo.getAuditTime());
        return lqw;
    }

    /**
     * 新增年检记录
     *
     * @param bo 年检记录
     * @return 是否新增成功
     */
    @Override
    public Boolean insertByBo(ZjkAnnualInspectionRecordsBo bo) {
        ZjkAnnualInspectionRecords add = MapstructUtils.convert(bo, ZjkAnnualInspectionRecords.class);
        validEntityBeforeSave(add);
        boolean flag = baseMapper.insert(add) > 0;
        if (flag) {
            bo.setId(add.getId());
        }
        return flag;
    }

    /**
     * 修改年检记录
     *
     * @param bo 年检记录
     * @return 是否修改成功
     */
    @Override
    public Boolean updateByBo(ZjkAnnualInspectionRecordsBo bo) {
        ZjkAnnualInspectionRecords update = MapstructUtils.convert(bo, ZjkAnnualInspectionRecords.class);
        validEntityBeforeSave(update);
        return baseMapper.updateById(update) > 0;
    }

    /**
     * 保存前的数据校验
     */
    private void validEntityBeforeSave(ZjkAnnualInspectionRecords entity){
        //TODO 做一些数据校验,如唯一约束
    }

    /**
     * 校验并批量删除年检记录信息
     *
     * @param ids     待删除的主键集合
     * @param isValid 是否进行有效性校验
     * @return 是否删除成功
     */
    @Override
    public Boolean deleteWithValidByIds(Collection<Long> ids, Boolean isValid) {
        if(isValid){
            //TODO 做一些业务上的校验,判断是否需要校验
        }
        return baseMapper.deleteByIds(ids) > 0;
    }
}
