package org.dromara.zjk.controller;

import org.dromara.common.core.domain.R;
import org.dromara.common.web.core.BaseController;
import org.dromara.zjk.domain.dto.SimpleExpertDto;
import org.dromara.zjk.domain.vo.ChartBaseVO;
import org.dromara.zjk.domain.vo.ChartRelExpertVO;
import org.dromara.zjk.service.ZjkExpertChartService;
import org.dromara.zjk.zwy.annotation.DecryptOperation;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;

/**
 * 专家库画像控制器
 *
 * @author : yanguohua
 * @version : 1.0
 * @date : 2024/10/30 16:57
 */
@RestController
@RequestMapping("/chart")
public class ZjkChartController extends BaseController {

    @Resource
    private ZjkExpertChartService zjkExpertChartService;

    /**
     * 专家画像榜基本信息
     */
    @DecryptOperation
    @GetMapping("/chartBase")
    public R<ChartBaseVO> getChartBase(Long userId) {
        return zjkExpertChartService.getChartBase(userId);
    }
    @GetMapping("/users")
    public R<List<SimpleExpertDto>> getExperts() {
        return zjkExpertChartService.getExperts();
    }

    /**
     * 专家知识图谱
     */
    @GetMapping("/sameOther")
    public R<ChartRelExpertVO> getSameOtherData(Long userId) {
        return zjkExpertChartService.getSameOtherData(userId);
    }


}
