package org.dromara.zjk.controller;

import java.util.List;

import lombok.RequiredArgsConstructor;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.validation.constraints.*;
import cn.dev33.satoken.annotation.SaCheckPermission;
import org.dromara.zjk.domain.ZjkCreditLv;
import org.dromara.zjk.domain.ZjkCreditUser;
import org.dromara.zjk.domain.vo.ZjkCreditUserVo;
import org.springframework.web.bind.annotation.*;
import org.springframework.validation.annotation.Validated;
import org.dromara.common.idempotent.annotation.RepeatSubmit;
import org.dromara.common.log.annotation.Log;
import org.dromara.common.web.core.BaseController;
import org.dromara.common.mybatis.core.page.PageQuery;
import org.dromara.common.core.domain.R;
import org.dromara.common.core.validate.AddGroup;
import org.dromara.common.core.validate.EditGroup;
import org.dromara.common.log.enums.BusinessType;
import org.dromara.common.excel.utils.ExcelUtil;
import org.dromara.zjk.domain.vo.ZjkCreditLvVo;
import org.dromara.zjk.domain.bo.ZjkCreditLvBo;
import org.dromara.zjk.service.IZjkCreditLvService;
import org.dromara.common.mybatis.core.page.TableDataInfo;

/**
 * 【请填写功能名称】
 * 前端访问路由地址为:/jyk/creditLv
 *
 * @author ygh
 * @date 2024-11-13
 */
@Validated
@RequiredArgsConstructor
@RestController
@RequestMapping("/creditLv")
public class ZjkCreditLvController extends BaseController {

    private final IZjkCreditLvService zjkCreditLvService;

    /**
     * 查询【请填写功能名称】列表
     */
//    @SaCheckPermission("jyk:creditLv:list")
    @GetMapping("/list")
    public R<List<ZjkCreditLvVo>> list() {
        return R.ok(zjkCreditLvService.queryPageList());
    }

    /**
     * 导出【请填写功能名称】列表
     */
    @SaCheckPermission("jyk:creditLv:export")
    @Log(title = "【请填写功能名称】", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(ZjkCreditLvBo bo, HttpServletResponse response) {
        List<ZjkCreditLvVo> list = zjkCreditLvService.queryList(bo);
        ExcelUtil.exportExcel(list, "【请填写功能名称】", ZjkCreditLvVo.class, response);
    }

    /**
     * 获取【请填写功能名称】详细信息
     *
     * @param id 主键
     */
    @SaCheckPermission("jyk:creditLv:query")
    @GetMapping("/{id}")
    public R<ZjkCreditLvVo> getInfo(@NotNull(message = "主键不能为空")
                                     @PathVariable Long id) {
        return R.ok(zjkCreditLvService.queryById(id));
    }

    /**
     * 新增【请填写功能名称】
     */
    @SaCheckPermission("jyk:creditLv:add")
    @Log(title = "【请填写功能名称】", businessType = BusinessType.INSERT)
    @RepeatSubmit()
    @PostMapping("/add")
    public R<Void> add(@Validated(AddGroup.class) @RequestBody ZjkCreditLvBo bo) {
        return toAjax(zjkCreditLvService.insertByBo(bo));
    }

    /**
     * 修改【请填写功能名称】
     */
    @SaCheckPermission("jyk:creditLv:edit")
    @Log(title = "【请填写功能名称】", businessType = BusinessType.UPDATE)
    @RepeatSubmit()
    @PostMapping("/edit")
    public R<Void> edit(@Validated(EditGroup.class) @RequestBody ZjkCreditLvBo bo) {
        return toAjax(zjkCreditLvService.updateByBo(bo));
    }

    /**
     * 删除【请填写功能名称】
     *
     * @param ids 主键串
     */
    @SaCheckPermission("jyk:creditLv:remove")
    @Log(title = "【请填写功能名称】", businessType = BusinessType.DELETE)
    @GetMapping("/delete/{ids}")
    public R<Void> remove(@NotEmpty(message = "主键不能为空")
                          @PathVariable Long[] ids) {
        return toAjax(zjkCreditLvService.deleteWithValidByIds(List.of(ids), true));
    }


    @GetMapping("/countReson")
    public List<ZjkCreditUserVo> countReson(@RequestBody ZjkCreditLvVo zjkCreditLvVo) {
        return zjkCreditLvService.countReson(zjkCreditLvVo);
    }
}
