package org.dromara.zjk.controller;

import cn.dev33.satoken.annotation.SaCheckRole;
import cn.dev33.satoken.annotation.SaMode;
import lombok.RequiredArgsConstructor;
import org.dromara.common.core.constant.TenantConstants;
import org.dromara.common.core.domain.R;
import org.dromara.zjk.domain.vo.JgStatisticsVO;
import org.dromara.zjk.service.ZjkJgHomeService;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;


/**
 * 机构管理员首页接口
 * 前端访问路由地址为:/zjkHome
 */
@Validated
@RequiredArgsConstructor
@RestController
@RequestMapping("/zjkHome")
public class ZjkJgHomeController {

    private final ZjkJgHomeService zjkJgHomeService;


    /**
     * 获取机构管理员首页统计数据
     * @return
     */
    @SaCheckRole(value={
            TenantConstants.JG_ROLE_KEY,
            TenantConstants.SUPER_ADMIN_ROLE_KEY,
            TenantConstants.TENANT_ADMIN_ROLE_KEY
    },mode = SaMode.OR)
    @GetMapping("/getJgStatistics")
    public R<JgStatisticsVO> getJgStatistics() {
        return R.ok(zjkJgHomeService.getJgStatistics());
    }

}
