package org.dromara.zjk.controller;

import java.util.List;

import cn.dev33.satoken.annotation.SaCheckRole;
import cn.dev33.satoken.annotation.SaMode;
import lombok.RequiredArgsConstructor;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.validation.constraints.*;
import cn.dev33.satoken.annotation.SaCheckPermission;
import org.dromara.common.core.constant.TenantConstants;
import org.springframework.web.bind.annotation.*;
import org.springframework.validation.annotation.Validated;
import org.dromara.common.idempotent.annotation.RepeatSubmit;
import org.dromara.common.log.annotation.Log;
import org.dromara.common.web.core.BaseController;
import org.dromara.common.mybatis.core.page.PageQuery;
import org.dromara.common.core.domain.R;
import org.dromara.common.core.validate.AddGroup;
import org.dromara.common.core.validate.EditGroup;
import org.dromara.common.log.enums.BusinessType;
import org.dromara.common.excel.utils.ExcelUtil;
import org.dromara.zjk.domain.vo.ZjkLearningMaterialsVo;
import org.dromara.zjk.domain.bo.ZjkLearningMaterialsBo;
import org.dromara.zjk.service.IZjkLearningMaterialsService;
import org.dromara.common.mybatis.core.page.TableDataInfo;

/**
 * 信用资料
 * 前端访问路由地址为:/jyk/learningMaterials
 *
 * @author ygh
 * @date 2024-11-26
 */
@Validated
@RequiredArgsConstructor
@RestController
@RequestMapping("/learningMaterials")
public class ZjkLearningMaterialsController extends BaseController {

    private final IZjkLearningMaterialsService zjkLearningMaterialsService;

    /**
     * 查询信用资料列表
     */
//    @SaCheckPermission("jyk:learningMaterials:list")
//    @SaCheckRole(value = {
//        TenantConstants.SUPER_ADMIN_ROLE_KEY,
//        TenantConstants.TENANT_ADMIN_ROLE_KEY,
//        TenantConstants.JG_ROLE_KEY,
//        TenantConstants.XM_ROLE_KEY,
//        TenantConstants.EXPERT_ROLE_KEY,
//    },mode = SaMode.OR)
    @GetMapping("/list")
    public TableDataInfo<ZjkLearningMaterialsVo> list(ZjkLearningMaterialsBo bo, PageQuery pageQuery) {
        return zjkLearningMaterialsService.queryPageList(bo, pageQuery);
    }

    /**
     * 导出信用资料列表
     */
//    @SaCheckPermission("jyk:learningMaterials:export")
//    @SaCheckRole(value = {
//        TenantConstants.SUPER_ADMIN_ROLE_KEY,
//        TenantConstants.TENANT_ADMIN_ROLE_KEY,
//        TenantConstants.JG_ROLE_KEY,
//        TenantConstants.XM_ROLE_KEY,
//        TenantConstants.EXPERT_ROLE_KEY,
//    },mode = SaMode.OR)
    @Log(title = "信用资料", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(ZjkLearningMaterialsBo bo, HttpServletResponse response) {
        List<ZjkLearningMaterialsVo> list = zjkLearningMaterialsService.queryList(bo);
        ExcelUtil.exportExcel(list, "信用资料", ZjkLearningMaterialsVo.class, response);
    }

    /**
     * 获取信用资料详细信息
     *
     * @param id 主键
     */
//    @SaCheckPermission("jyk:learningMaterials:query")
//    @SaCheckRole(value = {
//        TenantConstants.SUPER_ADMIN_ROLE_KEY,
//        TenantConstants.TENANT_ADMIN_ROLE_KEY,
//        TenantConstants.JG_ROLE_KEY,
//        TenantConstants.XM_ROLE_KEY,
//        TenantConstants.EXPERT_ROLE_KEY,
//    },mode = SaMode.OR)
    @GetMapping("/{id}")
    public R<ZjkLearningMaterialsVo> getInfo(@NotNull(message = "主键不能为空")
                                     @PathVariable Long id) {
        return R.ok(zjkLearningMaterialsService.queryById(id));
    }

    /**
     * 新增信用资料
     */
//    @SaCheckPermission("jyk:learningMaterials:add")
//    @SaCheckRole(value = {
//        TenantConstants.SUPER_ADMIN_ROLE_KEY,
//        TenantConstants.TENANT_ADMIN_ROLE_KEY,
//        TenantConstants.JG_ROLE_KEY,
//        TenantConstants.XM_ROLE_KEY,
//        TenantConstants.EXPERT_ROLE_KEY,
//    },mode = SaMode.OR)
    @Log(title = "信用资料", businessType = BusinessType.INSERT)
    @RepeatSubmit()
    @PostMapping("/add")
    public R<Void> add(@Validated(AddGroup.class) @RequestBody ZjkLearningMaterialsBo bo) {
        return toAjax(zjkLearningMaterialsService.insertByBo(bo));
    }

    /**
     * 修改信用资料
     */
//    @SaCheckPermission("jyk:learningMaterials:edit")
//    @SaCheckRole(value = {
//        TenantConstants.SUPER_ADMIN_ROLE_KEY,
//        TenantConstants.TENANT_ADMIN_ROLE_KEY,
//        TenantConstants.JG_ROLE_KEY,
//        TenantConstants.XM_ROLE_KEY,
//        TenantConstants.EXPERT_ROLE_KEY,
//    },mode = SaMode.OR)
    @Log(title = "信用资料", businessType = BusinessType.UPDATE)
    @RepeatSubmit()
    @PostMapping("/edit")
    public R<Void> edit(@Validated(EditGroup.class) @RequestBody ZjkLearningMaterialsBo bo) {
        return toAjax(zjkLearningMaterialsService.updateByBo(bo));
    }

    /**
     * 删除信用资料
     *
     * @param ids 主键串
     */
//    @SaCheckPermission("jyk:learningMaterials:remove")
//    @SaCheckRole(value = {
//        TenantConstants.SUPER_ADMIN_ROLE_KEY,
//        TenantConstants.TENANT_ADMIN_ROLE_KEY,
//        TenantConstants.JG_ROLE_KEY,
//        TenantConstants.XM_ROLE_KEY,
//        TenantConstants.EXPERT_ROLE_KEY,
//    },mode = SaMode.OR)
    @Log(title = "信用资料", businessType = BusinessType.DELETE)
    @GetMapping("/delete/{ids}")
    public R<Void> remove(@NotEmpty(message = "主键不能为空")
                          @PathVariable Long[] ids) {
        return toAjax(zjkLearningMaterialsService.deleteWithValidByIds(List.of(ids), true));
    }
}
