package org.dromara.zjk.domain;

import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;

@Data
@ExcelIgnoreUnannotated
@EqualsAndHashCode
public class ExpertBaseInfo {

    /**
     * 姓名
     */
    private String expertName;

    /**
     * 头像
     */
    private String photograph;

    /**
     * 工作单位
     */
    private String workUnit;

    /**
     * 职务
     */
    private String duty;

    /**
     * 积分
     */
    private BigDecimal pointCount;

    /**
     * 信用等级
     */
    private String creditName;

    /**
     * 评审项目次数
     */
    private Long reviewProjectCount;

    /**
     * 请假总次数
     */
    private Long leaveCount;

    /**
     * 专家互评人数
     */
    private Long evaluateCount;

    /**
     * 请假开始时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date startDate;

    /**
     * 请假结束时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date endDate;

    /**
     *  领域
     */
    private String performWorkId;

    private String status;
}
