package org.dromara.zjk.domain;

import org.dromara.common.tenant.core.TenantEntity;
import com.baomidou.mybatisplus.annotation.*;
import lombok.Data;
import lombok.EqualsAndHashCode;
import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.dromara.zjk.annotation.PropertyMsg;
import java.io.Serial;

/**
 * 【请填写功能名称】对象 zjk_learning_evaluate
 *
 * @author ygh
 * @date 2025-07-28
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("zjk_learning_evaluate")
public class LearningEvaluate extends TenantEntity {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * 租户号
     */
    @TableId(value = "id", type = IdType.ASSIGN_ID)
    private String ID;

    /**
     * 课程id;zjk_learning_course主键
     */
    @PropertyMsg(propertyName = "course_id")
    private Long courseId;

    /**
     * 难易程度
     */
    @PropertyMsg(propertyName = "diff_level")
    private Long diffLevel;

    /**
     * 掌握程度
     */
    @PropertyMsg(propertyName = "get_level")
    private Long getLevel;

    /**
     * 完成时间
     */
    @PropertyMsg(propertyName = "finish_time")
    private Date finishTime;

    /**
     * 学习心得
     */
    @PropertyMsg(propertyName = "remark")
    private String remark;


}
