package org.dromara.zjk.domain;

import org.dromara.common.tenant.core.TenantEntity;
import com.baomidou.mybatisplus.annotation.*;
import lombok.Data;
import lombok.EqualsAndHashCode;
import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.dromara.zjk.annotation.PropertyMsg;
import java.io.Serial;

/**
 * 【请填写功能名称】对象 zjk_learning_plan
 *
 * @author ygh
 * @date 2025-07-28
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("zjk_learning_plan")
public class LearningPlan extends TenantEntity {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * 租户号
     */
    @TableId(value = "id", type = IdType.ASSIGN_ID)
    private String ID;

    /**
     * 计划名称;zjk_learning_course主键
     */
    @PropertyMsg(propertyName = "plan_name")
    private String planName;

    /**
     * 计划开始时间
     */
    @PropertyMsg(propertyName = "start_time")
    private Date startTime;

    /**
     * 计划结束时间
     */
    @PropertyMsg(propertyName = "end_time")
    private Date endTime;

    /**
     * 学习目标
     */
    @PropertyMsg(propertyName = "study_target")
    private String studyTarget;


}
