package org.dromara.zjk.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonAlias;
import lombok.Data;
import org.dromara.zjk.zwy.annotation.EncryptSensitive;


import java.util.Date;

@Data
public class ProfessorsInfo {
    /** 专家姓名 */
    @JsonAlias("professorName")
    private String expertName;

    /** 工作单位 */
    @JsonAlias("professorWorkUnit")
    private String workUnit;

    /** 身份证号 */
    @JsonAlias("professorIdentity")
    @EncryptSensitive
    private String idCard;

    /** 职务 */
    @JsonAlias("professorPosition")
    private String duty;

    /** 手机 */
    @JsonAlias("professorPhone")
    @EncryptSensitive
    private String contact;

    /** 邮箱 */
    @JsonAlias("professorEmail")
    @EncryptSensitive
    private String email;

    /** 专业领域对应的类型id */
    @JsonAlias("professorDeclareCategory")
    private String professorDeclareCategory;



    /** 专业领域对应的类型名称 */
    @JsonAlias("professorDeclareCategoryName")
    private String professorDeclareCategoryName;

    /** 专业领域 */
    @JsonAlias("professionalField")
    private String professionalField;

    /** 证书职称专业 */
    @JsonAlias("certMajor")
    private String certMajor;

    /** 专家类别 */
    @JsonAlias("professorType")
    private String professorType;

    /** 专家类别名称 */
    @JsonAlias("professorTypeName")
    private String professorTypeName;

    /** 创建日期 */
    @JsonIgnore
    private Date createTime;

    /** 更新日期 */
    @JsonIgnore
    private Date updateTime;

    /** 创建人 */
    @JsonIgnore
    private String createBy;

    /** 更新人 */
    @JsonIgnore
    private String updateBy;

}
