package org.dromara.zjk.domain;

import org.dromara.common.tenant.core.TenantEntity;
import com.baomidou.mybatisplus.annotation.*;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.dromara.zjk.annotation.PropertyMsg;
import java.io.Serial;

/**
 * 信用记录对象 zjk_credit
 *
 * @author ygh
 * @date 2024-11-11
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("zjk_credit")
public class ZjkCredit extends TenantEntity {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * 租户号
     */
    @PropertyMsg(propertyName = "ID")
    private Long creditId;

    /**
     * 信用数值
     */
    @PropertyMsg(propertyName = "credit")
    private Long credit;

    /**
     * 信用事由外键
     */
    @PropertyMsg(propertyName = "rule_id")
    private Long ruleId;

    /**
     * 专家id
     */
    @PropertyMsg(propertyName = "expert_id")
    private Long expertId;

    /**
     * 用户id
     */
    @PropertyMsg(propertyName = "user_id")
    private Long userId;

    //当前信用分
    private Long creditCount;


}
