package org.dromara.zjk.domain;

import org.dromara.common.tenant.core.TenantEntity;
import com.baomidou.mybatisplus.annotation.*;
import lombok.Data;
import lombok.EqualsAndHashCode;
import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.dromara.zjk.annotation.PropertyMsg;
import java.io.Serial;

/**
 * 信用规则对象 zjk_credit_rule
 *
 * @author ygh
 * @date 2024-11-11
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("zjk_credit_rule")
public class ZjkCreditRule extends TenantEntity {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * 租户号
     */
    @PropertyMsg(propertyName = "ID")
    private Long ID;

    /**
     * 规则名称
     */
    @PropertyMsg(propertyName = "rule_name")
    private String ruleName;

    /**
     * 到期时间
     */
    @PropertyMsg(propertyName = "expire_time")
    private Date expireTime;

    /**
     * 是否永久
     */
    @PropertyMsg(propertyName = "is_forever")
    private Long isForever;

    /**
     * 启用标识
     */
    @PropertyMsg(propertyName = "status")
    private Long status;

    /**
     * 每次得分
     */
    @PropertyMsg(propertyName = "each_score")
    private Long eachScore;

    /**
     * 信用规则code
     */
    @PropertyMsg(propertyName = "rule_key")
    private String ruleKey;

    /**
     * 信用获得事由
     */
    @PropertyMsg(propertyName = "point_reason")
    private String pointReason;


}
