package org.dromara.zjk.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import org.dromara.common.mybatis.core.domain.BaseEntity;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 专家评价
 *
 * @TableName zjk_evaluate
 */
@TableName(value = "zjk_evaluate")
@Data
public class ZjkEvaluate extends BaseEntity implements Serializable {
    /**
     * 租户号
     */
    @TableId(value = "id", type = IdType.ASSIGN_ID)
    private String id;

    /**
     * 待评人
     */
    @TableField(value = "evaluate_user")
    private Long evaluateUser;

    /**
     * 专家职务
     */
    @TableField(value = "expert_post")
    private String expertPost;

    /**
     * 出席情况1：出席；0：未出席
     */
    @TableField(value = "is_present")
    private String isPresent;
    /**
     * 项目id
     */
    @TableField(value = "item_id")
    private String itemId;

    /**
     * 项目阶段
     */
    @TableField(value = "item_stage")
    private Integer itemStage;

    /**
     * 业务水平得分
     */
    @TableField(value = "bus_level_score")
    private BigDecimal busLevelScore;

    /**
     * 工作态度得分
     */
    @TableField(value = "work_attitude_score")
    private BigDecimal workAttitudeScore;

    /**
     * 合规评审得分
     */
    @TableField(value = "right_approval_score")
    private BigDecimal rightApprovalScore;

    /**
     * 专家评语
     */
    @TableField(value = "expert_comment")
    private String expertComment;

    /**
     * 专家评价文件id集合
     */
    @TableField(value = "evaluate_file")
    private String evaluateFile;

    /**
     * 评价状态;1:已评价；0：未评价
     */
    @TableField(value = "status")
    private Integer status;

    /**
     * 租户id
     */
    @TableField(value = "tenant_id")
    private String tenantId;
    /**
     * 评价角色(1:专家互评;0:机构管理员评价;2项目管理员评价)
     */
    @TableField(value = "source_role")
    private Integer sourceRole;

    @TableField(exist = false)
    private static final long serialVersionUID = 1L;
}
