package org.dromara.zjk.domain;

import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.dromara.common.tenant.core.TenantEntity;
import org.dromara.zjk.annotation.PropertyMsg;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serial;
import java.util.Date;

/**
 * 专家库技术资格关系表对象 zjk_expert_professional
 *
 * @author zhangzhou
 * @date 2024-11-01
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("zjk_expert_professional")
public class ZjkExpertProfessional extends TenantEntity {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * id
     */
    private Long id;

    /**
     * 用户 id
     */
    private Long userId;

    /**
     * 专家 id
     */
    private Long expertId;

    /**
     * 技术资格
     */
    @PropertyMsg(propertyName = "技术资格")
    private String professional;

    /**
     * 技术资格取得时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd",timezone="GMT+8")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @PropertyMsg(propertyName = "技术资格取得时间")
    private Date professionalDate;

    /**
     * 状态
     */
    private Integer status;

    /**
     * 备注
     */
    private String remark;


}
