package org.dromara.zjk.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import org.dromara.common.mybatis.core.domain.BaseEntity;

import java.util.Date;

/**
 * 发票报表
 *
 * @TableName zjk_invoice_report
 */
@TableName(value = "zjk_invoice_report")
@Data
public class ZjkInvoiceReport extends BaseEntity {
    /**
     * 租户号
     */
    @TableId(value = "ID", type = IdType.ASSIGN_ID)
    private String id;

    /**
     * 报表名称
     */
    @TableField(value = "report_name")
    private String reportName;

    /**
     * 报表编号
     */
    @TableField(value = "report_code")
    private String reportCode;

    /**
     * 报表类型;（1：年报表；0：月报表）
     */
    @TableField(value = "report_type")
    private Integer reportType;

    /**
     * 时间范围开始
     */
    @TableField(value = "date_range_start")
    private Date dateRangeStart;

    /**
     * 时间范围结束
     */
    @TableField(value = "date_range_end")
    private Date dateRangeEnd;

    /**
     * 租户id
     */
    @TableField(value = "tenant_id")
    private String tenantId;
}
