package org.dromara.zjk.domain;

import com.alibaba.excel.annotation.ExcelProperty;
import org.dromara.common.tenant.core.TenantEntity;
import com.baomidou.mybatisplus.annotation.*;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.dromara.zjk.annotation.PropertyMsg;
import java.io.Serial;

/**
 * 【请填写功能名称】对象 zjk_learning_materials
 *
 * @author ygh
 * @date 2024-11-26
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("zjk_learning_materials")
public class ZjkLearningMaterials extends TenantEntity {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    @PropertyMsg(propertyName = "id")
    private Long id;

    /**
     * 乐观锁
     */
    @PropertyMsg(propertyName = "revision")
    private Long revision;

    /**
     * 资料id
     */
    @PropertyMsg(propertyName = "materials_id")
    private String materialsId;

    /**
     * 资料名称
     */
    @PropertyMsg(propertyName = "资料名称")
    private String materialsName;

    /**
     * 观看次数
     */
    @PropertyMsg(propertyName = "materials_count")
    private String materialsCount;

    /**
     * 状态（0，失效，1.正常）
     */
    @PropertyMsg(propertyName = "status")
    private String status;

    /**
     * 逻辑删除（1，失效，0.正常）
     */
    @PropertyMsg(propertyName = "del_falg")
    private String delFalg;

    /**
     * url地址
     * */
    private String materialsUrl;


}
