package org.dromara.zjk.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.util.Date;
import lombok.Data;
import org.dromara.common.mybatis.core.domain.BaseEntity;

/**
 * 请假规则
 * @TableName zjk_leave_rule
 */
@TableName(value ="zjk_leave_rule")
@Data
public class ZjkLeaveRule extends BaseEntity implements Serializable {
    /**
     * 租户号
     */
    @TableId(value = "gid",type = IdType.ASSIGN_ID)
    private String gid;

    /**
     * 请假时长
     */
    @TableField(value = "leave_day")
    private Long leaveDay;

    /**
     * 请假提前天数
     */
    @TableField(value = "before_day")
    private String beforeDay;

    /**
     * 项目评审前提前小时数
     */
    @TableField(value = "pro_before_hour")
    private String proBeforeHour;

    /**
     * 租户id
     */
    @TableField(value = "tenant_id")
    private String tenantId;



    @TableField(exist = false)
    private static final long serialVersionUID = 1L;
}
