package org.dromara.zjk.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import org.dromara.common.mybatis.core.domain.BaseEntity;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 积分规则表
 *
 * @TableName zjk_point_rule
 */
@TableName(value = "zjk_point_rule")
@Data
public class ZjkPointRule extends BaseEntity {
    /**
     * 租户号
     */
    @TableId(value = "ID", type = IdType.ASSIGN_ID)
    private Long id;

    /**
     * 规则名称
     */
    @TableField(value = "rule_name")
    private String ruleName;

    /**
     * 到期时间
     */
    @TableField(value = "expire_time")
    private Date expireTime;

    /**
     * 是否永久
     */
    @TableField(value = "is_forever")
    private Long isForever;

    /**
     * 规则编码
     */
    @TableField(value = "rule_key")
    private String ruleKey;
    /**
     * 启用标识
     */
    @TableField(value = "status")
    private Object status;
    /**
     * 积分分值
     */
    @TableField(value = "each_score")
    private BigDecimal eachScore;



    @TableField(exist = false)
    private static final long serialVersionUID = 1L;
}
