package org.dromara.zjk.domain;

import com.baomidou.mybatisplus.annotation.*;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import lombok.Data;
import org.dromara.common.mybatis.core.domain.BaseEntity;

/**
 * 积分用户
 * @TableName zjk_point_user
 */
@TableName(value ="zjk_point_user")
@Data
public class ZjkPointUser extends BaseEntity{
    /**
     * 租户号
     */
    @TableId(value = "ID",type = IdType.ASSIGN_ID)
    private String id;

    /**
     * 用户id
     */
    @TableField(value = "user_id")
    private Long userId;

    /**
     * 专家id
     */
    @TableField(value = "expert_id")
    private Long expertId;

    /**
     * 奖励id
     */
    @TableField(value = "reward_id")
    private String rewardId;

    /**
     * 奖励内容
     */
    @TableField(value = "reward_title")
    private String rewardTitle;

    /**
     * 总积分
     */
    @TableField(value = "point_count")
    private BigDecimal pointCount;

    /**
     * 审核状态;1：已审核；2：审核不通过；0：初始不需审核
     */
    @TableField(value = "check_status")
    private Integer checkStatus;
    /**
     * 备注
     */
    @TableField(value = "remark")
    private String remark;
    /**
     * 创建时间
     */
    @TableField(value = "check_time")
    private Date checkTime;
    /**
     * 积分变更时间
     */
    @TableField(value = "change_time")
    private Date changeTime;

    @TableField(exist = false)
    private static final long serialVersionUID = 1L;
}
