package org.dromara.zjk.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import org.dromara.common.mybatis.core.domain.BaseEntity;

import java.io.Serializable;

/**
 * 短信模板
 *
 * @TableName zjk_sms_template
 */
@TableName(value = "zjk_sms_template")
@Data
public class ZjkSmsTemplate extends BaseEntity implements Serializable {
    /**
     * 租户号
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 模板类型;1：专家抽取发送；2：请假通知发送
     */
    @TableField(value = "tml_type")
    private String tmlType;

    /**
     * 模板内容
     */
    @TableField(value = "tml_content")
    private String tmlContent;

    /**
     * 启用标识（默认启用）;1：启用 0：未启用
     */
    @TableField(value = "start_flag")
    private Integer startFlag;
    /**
     * 短信标头
     */
    @TableField(value = "title")
    private String title;


}
