package org.dromara.zjk.domain.bo;

import com.fasterxml.jackson.annotation.JsonFormat;
import org.dromara.zjk.domain.ZjkApprovalProcessLogs;
import org.dromara.common.mybatis.core.domain.BaseEntity;
import org.dromara.common.core.validate.AddGroup;
import org.dromara.common.core.validate.EditGroup;
import io.github.linpeilie.annotations.AutoMapper;
import lombok.Data;
import lombok.EqualsAndHashCode;
import jakarta.validation.constraints.*;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * 审批流程记录业务对象 zjk_approval_process_logs
 *
 * @author zhangzhou
 * @date 2024-11-06
 */
@Data
@EqualsAndHashCode(callSuper = true)
@AutoMapper(target = ZjkApprovalProcessLogs.class, reverseConvertGenerate = false)
public class ZjkApprovalProcessLogsBo extends BaseEntity {

    /**
     * id
     */
    @NotNull(message = "id不能为空", groups = { AddGroup.class, EditGroup.class })
    private Long id;

    /**
     * 操作项
     */
    private String actionItem;

    /**
     * 操作内容
     */
    private String actionContent;

    /**
     * 审批意见
     */
    private String approvalOpinions;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date startTime;
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date endTime;

}
