package org.dromara.zjk.domain.bo;

import org.dromara.common.mybatis.core.domain.BaseEntity;
import org.dromara.common.core.validate.AddGroup;
import org.dromara.common.core.validate.EditGroup;
import io.github.linpeilie.annotations.AutoMapper;
import lombok.Data;
import lombok.EqualsAndHashCode;
import jakarta.validation.constraints.*;
import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.dromara.zjk.domain.ZjkCreditLv;

/**
 * 【请填写功能名称】业务对象 zjk_credit_lv
 *
 * @author ygh
 * @date 2024-11-13
 */
@Data
@EqualsAndHashCode(callSuper = true)
@AutoMapper(target = ZjkCreditLv.class, reverseConvertGenerate = false)
public class ZjkCreditLvBo extends BaseEntity {

    /**
     * 主键
     */
    @NotNull(message = "主键不能为空", groups = { AddGroup.class, EditGroup.class })
    private Long id;

    /**
     * 信用等级名称
     */
    @NotBlank(message = "信用等级名称不能为空", groups = { AddGroup.class, EditGroup.class })
    private String creditName;

    /**
     * 信用区间>
     */
    @NotNull(message = "信用区间>不能为空", groups = { AddGroup.class, EditGroup.class })
    private Long creditSectionLe;

    /**
     * 信用区间<
     */
    @NotNull(message = "信用区间<不能为空", groups = { AddGroup.class, EditGroup.class })
    private Long creditSectionGe;


}
