package org.dromara.zjk.domain.bo;

import org.dromara.zjk.domain.ZjkCreditRule;
import org.dromara.common.mybatis.core.domain.BaseEntity;
import org.dromara.common.core.validate.AddGroup;
import org.dromara.common.core.validate.EditGroup;
import io.github.linpeilie.annotations.AutoMapper;
import lombok.Data;
import lombok.EqualsAndHashCode;
import jakarta.validation.constraints.*;
import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 信用规则业务对象 zjk_credit_rule
 *
 * @author ygh
 * @date 2024-11-11
 */
@Data
@EqualsAndHashCode(callSuper = true)
@AutoMapper(target = ZjkCreditRule.class, reverseConvertGenerate = false)
public class ZjkCreditRuleBo extends BaseEntity {

    /**
     * 租户号
     */
    @NotNull(message = "租户号不能为空", groups = { AddGroup.class, EditGroup.class })
    private Long ID;

    /**
     * 规则名称
     */
    @NotBlank(message = "规则名称不能为空", groups = { AddGroup.class, EditGroup.class })
    private String ruleName;

    /**
     * 到期时间
     */
    @NotNull(message = "到期时间不能为空", groups = { AddGroup.class, EditGroup.class })
    private Date expireTime;

    /**
     * 是否永久
     */
    @NotNull(message = "是否永久不能为空", groups = { AddGroup.class, EditGroup.class })
    private Long isForever;

    /**
     * 启用标识
     */
    @NotNull(message = "启用标识不能为空", groups = { AddGroup.class, EditGroup.class })
    private Long status;

    /**
     * 每次得分
     */
    @NotNull(message = "每次得分不能为空", groups = { AddGroup.class, EditGroup.class })
    private Long eachScore;

    /**
     * 信用规则code
     */
    @NotBlank(message = "信用规则code不能为空", groups = { AddGroup.class, EditGroup.class })
    private String ruleKey;

    /**
     * 信用获得事由
     */
    @NotBlank(message = "信用获得事由不能为空", groups = { AddGroup.class, EditGroup.class })
    private String pointReason;

    /*开始日期*/
    private String startTime;

    /*结束日期*/
    private String endTime;

}
