package org.dromara.zjk.domain.bo;

import org.dromara.zjk.domain.ZjkExpertMajor;
import org.dromara.common.mybatis.core.domain.BaseEntity;
import org.dromara.common.core.validate.AddGroup;
import org.dromara.common.core.validate.EditGroup;
import io.github.linpeilie.annotations.AutoMapper;
import lombok.Data;
import lombok.EqualsAndHashCode;
import jakarta.validation.constraints.*;

/**
 * 专家库 专业关系表业务对象 zjk_expert_major
 *
 * @author ygh
 * @date 2024-11-01
 */
@Data
@EqualsAndHashCode(callSuper = true)
@AutoMapper(target = ZjkExpertMajor.class, reverseConvertGenerate = false)
public class ZjkExpertMajorBo extends BaseEntity {

    /**
     * id
     */
    @NotNull(message = "id不能为空", groups = { AddGroup.class, EditGroup.class })
    private Long id;

    /**
     * 用户 id
     */
    @NotNull(message = "用户 id不能为空", groups = { AddGroup.class, EditGroup.class })
    private Long userId;

    /**
     * 专家 id
     */
    @NotNull(message = "专家 id不能为空", groups = { AddGroup.class, EditGroup.class })
    private Long expertId;

    /**
     * 专业
     */
    @NotBlank(message = "专业不能为空", groups = { AddGroup.class, EditGroup.class })
    private String major;

    /**
     * 学历
     */
    @NotNull(message = "学历不能为空", groups = { AddGroup.class, EditGroup.class })
    private Integer degree;

    /**
     * 状态
     */
    @NotNull(message = "状态不能为空", groups = { AddGroup.class, EditGroup.class })
    private Integer status;

    /**
     * 备注
     */
    @NotBlank(message = "备注不能为空", groups = { AddGroup.class, EditGroup.class })
    private String remark;


}
