package org.dromara.zjk.domain.bo;

import org.dromara.zjk.domain.ZjkLearningCreditRecord;
import org.dromara.common.mybatis.core.domain.BaseEntity;
import org.dromara.common.core.validate.AddGroup;
import org.dromara.common.core.validate.EditGroup;
import io.github.linpeilie.annotations.AutoMapper;
import lombok.Data;
import lombok.EqualsAndHashCode;
import jakarta.validation.constraints.*;
import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 【请填写功能名称】业务对象 zjk_learning_credit_record
 *
 * @author ygh
 * @date 2024-11-26
 */
@Data
@EqualsAndHashCode(callSuper = true)
@AutoMapper(target = ZjkLearningCreditRecord.class, reverseConvertGenerate = false)
public class ZjkLearningCreditRecordBo extends BaseEntity {

    /**
     * 主键
     */
    private Long id;

    /**
     * 乐观锁
     */
    private Long revision;

    /**
     * 用户id
     */
    private Long userId;

    /**
     * 资料id
     */
    @NotNull(message = "资料id不能为空", groups = { AddGroup.class, EditGroup.class })
    private Long learningId;

    /**
     * 观看时间
     */
    private Date viewingTime;

    /**
     * 删除字段
     */
    private Long delFalg;


}
