package org.dromara.zjk.domain.bo;

import org.dromara.zjk.domain.ZjkProduct;
import org.dromara.common.mybatis.core.domain.BaseEntity;
import org.dromara.common.core.validate.AddGroup;
import org.dromara.common.core.validate.EditGroup;
import io.github.linpeilie.annotations.AutoMapper;
import lombok.Data;
import lombok.EqualsAndHashCode;
import jakarta.validation.constraints.*;
import org.dromara.zjk.expert.expertPaper.domain.ZjkExpertPaper;
import org.dromara.zjk.expert.expertPatent.domain.ZjkExpertPatent;
import org.dromara.zjk.zwy.annotation.EncryptSensitive;

import java.util.List;

/**
 * 项目管理业务对象 zjk_product
 *
 * @author ygh
 * @date 2024-11-01
 */
@Data
@EqualsAndHashCode(callSuper = true)
@AutoMapper(target = ZjkProduct.class, reverseConvertGenerate = false)
public class ZjkProductBo extends BaseEntity {

    /**
     * $column.columnComment
     */
    @NotBlank(message = "id", groups = { EditGroup.class })
    private Long id;

    /**
     * $column.columnComment
     */
    @NotBlank(message = "项目编号不能为空", groups = { AddGroup.class })
    private String productSn;

    /**
     * $column.columnComment
     */
    @NotBlank(message = "项目名称不能为空", groups = { AddGroup.class})
    @Max(50)
    private String productName;

    /**
     * $column.columnComment
     */
    @NotBlank(message = "项目类型不能为空", groups = { AddGroup.class })
    private String productType;

    /**
     * $column.columnComment
     */
    @NotBlank(message = "项目规模不能为空", groups = { AddGroup.class})
    private String productScale;

    /**
     * $column.columnComment
     */
    @NotBlank(message = "单位不能为空", groups = { AddGroup.class})
    @Max(50)
    private String productUnit;

    /**
     * $column.columnComment
     */
    @NotBlank(message = "单位联系人不能为空", groups = { AddGroup.class})
    @Max(50)
    private String unitBy;

    /**
     * $column.columnComment
     */
    @EncryptSensitive
    @NotBlank(message = "单位联系人方式不能为空", groups = { AddGroup.class})
    @Max(50)
    private String unitConcat;

    /**
     * $column.columnComment
     */
    @NotBlank(message = "项目简介不能为空", groups = { AddGroup.class})
    @Max(50)
    private String productBrief;

    /**
     * $column.columnComment
     */
    private String productDataUrl;


    private String search;

    private Long userId;

    private List<Long> ids;

    private List<ZjkExpertPaper> zjkExpertPaperList;

    private List<ZjkExpertPatent> zjkExpertPatentsList;

    private String reviewSn;

    private Long productReviewId;
    private Integer approvalStatus;
    private String approvalReason;
}
