package org.dromara.zjk.domain.bo;

import org.dromara.common.mybatis.core.domain.BaseEntity;
import org.dromara.common.core.validate.AddGroup;
import org.dromara.common.core.validate.EditGroup;
import io.github.linpeilie.annotations.AutoMapper;
import lombok.Data;
import lombok.EqualsAndHashCode;
import jakarta.validation.constraints.*;
import org.dromara.zjk.domain.ZjkProjectEvaluation;

import java.util.Date;

/**
 * 项目总结评价业务对象 zjk_project_evaluation
 *
 * @author ygh
 * @date 2024-11-08
 */
@Data
@EqualsAndHashCode(callSuper = true)
@AutoMapper(target = ZjkProjectEvaluation.class, reverseConvertGenerate = false)
public class ZjkProjectEvaluationBo extends BaseEntity {

    public static final String 项目总结评价不能为空 = "项目总结评价不能为空";
    /**
     * 主键
     */
    private Long id;

    /**
     * 项目总结id
     */
    private Long productSummarizeId;

    /**
     * 目标达成
     */
    private Long goalAchievement;

    /**
     * 交付质量
     */
    private Long deliveryQuality;

    /**
     * 成本控制
     */
    private Long costControl;

    /**
     * 风险管理
     */
    private Long riskManagement;

    /**
     * 项目价值
     */
    private Long projectValue;

    /**
     * 项目总结评价文件id集合
     */
    private String evaluateFile;

    /**
     * 项目总结评价
     */
    private String projectSummaryEvaluation;

    private Long summarizeId;


}
