package org.dromara.zjk.domain.bo;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import org.dromara.common.mybatis.core.domain.BaseEntity;
import org.dromara.zjk.domain.ZjkReviewPhase;

import java.io.IOException;
import java.util.*;

/**
 * 屏蔽设置业务对象 zjk_expert_item
 *
 * @author ygh
 * @date 2024-10-29
 */
@Data
@EqualsAndHashCode(callSuper = true)
@AllArgsConstructor
@NoArgsConstructor
public class ZjkProjectExpertItemBo extends BaseEntity {

    //主键
    private Long id;
    //项目id
    private Long itemid;
    //当前专家的id
    private Long expertid;
    //计划抽取人数
    private Integer count;
    //抽取方式
    private String mode;
    //指定专家
    private List<Long> expertsId;
    //指定数量
    private Long expertsCout;
    //屏蔽限制
    private List<Long> extractioRestrictio;
    //回避专家
    private List<Long> expertIds;
    //回避单位
    private List<String> unit;
    //抽取区域
    private List<String> region;
    //补抽
    private Boolean redraw;
    //评审阶段
    private String reviewSn;
    //评审地点
    private String reviewPlace;
    //评审时间
    private Date reviewTime;
    //截至时间
    private Date noticeTime;
    //省-市-县
    private String provinces;
    //补抽人数
    private Integer supplementNum;
    //抽取领域
    private Map<Long,Long> areaList;

//    private List<ExpertItemAreaBo> boList;
    //抽取省市县
    @JsonDeserialize(using = ExtractAreaDeserializer.class)
    private List<String> extractArea = new ArrayList<>();
    //重抽原因
    private String causeRepum;
    //抽取规则id
    private Long reviewId;
    //抽取规则对象
    private ZjkReviewPhase zjkReviewPhase;

    private Long itemExtreationId;

    // 自定义反序列化器
    public static class ExtractAreaDeserializer extends JsonDeserializer<List<String>> {
        @Override
        public List<String> deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            if(p.getValueAsString()!=null) {
                String[] parts = p.getValueAsString().split(",");
                return new ArrayList<>(Arrays.asList(parts));
            }
            return new ArrayList<>();
        }
    }
}
