package org.dromara.zjk.domain.vo;

import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import com.alibaba.excel.annotation.ExcelProperty;
import io.github.linpeilie.annotations.AutoMapper;
import lombok.Data;
import org.dromara.zjk.domain.InoutCheck;

import java.io.Serial;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;


/**
 * 【请填写功能名称】视图对象 zjk_inout_check
 *
 * @author ygh
 * @date 2025-07-30
 */
@Data
@ExcelIgnoreUnannotated
public class CheckSupportVo implements Serializable {

    @Serial
    private static final long serialVersionUID = 1L;
    private String productId;
    private String expertId;
    @ExcelProperty(value = "专家姓名")
    private String expertName;

    /**
     * 职称等级
     */
    @ExcelProperty(value = "职称等级")
    private String proLevel;
    /**
     * 联系电话
     */
    @ExcelProperty(value = "联系电话")
    private String contact;
    /**
     * 身份证号
     */
    @ExcelProperty(value = "身份证号")
    private String idcard;
    /**
     * 评审阶段
     */
    @ExcelProperty(value = "评审阶段")
    private String reviewSnName;
    /**
     * 评审阶段
     */
    private String reviewSn;

    /**
     * 费用标准
     */
    @ExcelProperty(value = "费用标准")
    private BigDecimal expertMoney;
    /**
     * 费用总额
     */
    @ExcelProperty(value = "费用总额")
    private BigDecimal expertTypeMoneyFee;
    /**
     * 开票情况 （已开票/未开票）
     */
    @ExcelProperty(value = "开票情况")
    private String invStu;
    /**
     * 开票总金额
     */
    @ExcelProperty(value = "开票总金额")
    private BigDecimal invoiceMoney;
    /**
     * 发票名称
     */
    @ExcelProperty(value = "发票名称")
    private String invName;
    /**
     * 发票oss id
     */
    private String invFileId;
    /**
     * 多张发票的id集合
     */
    private List<String> fids;
    /**
     * 发票oss id
     */
    @ExcelProperty(value = "发票名称")
    private String invFileName;

}
