package org.dromara.zjk.domain.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

@Data
public class ProductPanoramaVo {
    /**
     * 项目id
     */

    private Long productId;

    /**
     * 项目名称
     */
    private String productName;

    /**
     * 项目类型
     */
    private String productType;

    /**
     * 评审时间
     */
    private Date reviewTime;

    /**
     * 评审阶段
     */
    private String reviewSn;

    /**
     * 评审id
     */
    private Long reviewId;

    /**
     * 单位i
     */
    private String workUnit;

    /**
     * 项目规模
     */
    private Integer productScale;
    /**
     * 最大规模
     */
    private Integer maxProductScale;

    /**
     * 最小规模
     */
    private Integer minProductScale;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date startTime;
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date endTime;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;

    /**
     * 评审id
     */
    private Long deptId;
}
