package org.dromara.zjk.domain.vo;

import org.dromara.zjk.domain.ZjkCredit;
import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import com.alibaba.excel.annotation.ExcelProperty;
import org.dromara.common.excel.annotation.ExcelDictFormat;
import org.dromara.common.excel.convert.ExcelDictConvert;
import io.github.linpeilie.annotations.AutoMapper;
import lombok.Data;

import java.io.Serial;
import java.io.Serializable;
import java.util.Date;



/**
 * 信用记录视图对象 zjk_credit
 *
 * @author ygh
 * @date 2024-11-11
 */
@Data
@ExcelIgnoreUnannotated
@AutoMapper(target = ZjkCredit.class)
public class ZjkCreditVo implements Serializable {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * 租户号
     */
    @ExcelProperty(value = "租户号")
    private Long creditId;

    /**
     * 信用数值
     */
    @ExcelProperty(value = "信用数值")
    private Long credit;

    /**
     * 信用事由外键
     */
    @ExcelProperty(value = "信用事由外键")
    private Long ruleId;

    /**
     * 创建人
     */
    @ExcelProperty(value = "创建人")
    private Long createBy;

    /**
     * 创建时间
     */
    @ExcelProperty(value = "创建时间")
    private Date createTime;

    /**
     * 更新人
     */
    @ExcelProperty(value = "更新人")
    private Long updateBy;

    /**
     * 更新时间
     */
    @ExcelProperty(value = "更新时间")
    private Date updateTime;

    /**
     * 专家id
     */
    @ExcelProperty(value = "专家id")
    private Long expertId;

    /**
     * 用户id
     */
    @ExcelProperty(value = "用户id")
    private Long userId;


}
