package org.dromara.zjk.domain.vo;

import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import com.alibaba.excel.annotation.ExcelProperty;
import io.github.linpeilie.annotations.AutoMapper;
import lombok.Data;
import org.dromara.zjk.domain.ZjkExpertHistory;

import java.io.Serial;
import java.io.Serializable;



/**
 * 专家记录变更历史表视图对象 zjk_expert_history
 *
 * @author zhangzhou
 * @date 2024-11-02
 */
@Data
@ExcelIgnoreUnannotated
@AutoMapper(target = ZjkExpertHistory.class)
public class ZjkExpertHistoryVo implements Serializable {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * id
     */
    @ExcelProperty(value = "id")
    private Long id;

    /**
     * 旧数据
     */
    @ExcelProperty(value = "旧数据")
    private String oldData;

    /**
     * 新数据
     */
    @ExcelProperty(value = "新数据")
    private String newData;

    /**
     * 变更字段
     */
    @ExcelProperty(value = "变更字段")
    private String modifiedFields;

    /**
     * 备注
     */
    @ExcelProperty(value = "备注")
    private String remark;

    /**
     * 是否删除
     */
    @ExcelProperty(value = "是否删除")
    private Long deleteFlag;


}
