package org.dromara.zjk.domain.vo;

import org.dromara.zjk.domain.ZjkExpertMajor;
import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import com.alibaba.excel.annotation.ExcelProperty;
import org.dromara.common.excel.annotation.ExcelDictFormat;
import org.dromara.common.excel.convert.ExcelDictConvert;
import io.github.linpeilie.annotations.AutoMapper;
import lombok.Data;

import java.io.Serial;
import java.io.Serializable;
import java.util.Date;



/**
 * 专家库 专业关系表视图对象 zjk_expert_major
 *
 * @author ygh
 * @date 2024-11-01
 */
@Data
@ExcelIgnoreUnannotated
@AutoMapper(target = ZjkExpertMajor.class)
public class ZjkExpertMajorVo implements Serializable {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * id
     */
    @ExcelProperty(value = "id")
    private Long id;

    /**
     * 用户 id
     */
    @ExcelProperty(value = "用户 id")
    private Long userId;

    /**
     * 专家 id
     */
    @ExcelProperty(value = "专家 id")
    private Long expertId;

    /**
     * 专业
     */
    @ExcelProperty(value = "专业")
    private String major;

    /**
     * 学历
     */
    @ExcelProperty(value = "学历", converter = ExcelDictConvert.class)
    @ExcelDictFormat(dictType = "degree_type")
    private Integer degree;

    /**
     * 租户号
     */
    @ExcelProperty(value = "租户号")
    private String tenantId;

    /**
     * 状态
     */
    @ExcelProperty(value = "状态")
    private Integer status;

    /**
     * 备注
     */
    @ExcelProperty(value = "备注")
    private String remark;


}
