package org.dromara.zjk.domain.vo;

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.dromara.zjk.domain.ZjkExpertProfessional;
import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import com.alibaba.excel.annotation.ExcelProperty;
import org.dromara.common.excel.annotation.ExcelDictFormat;
import org.dromara.common.excel.convert.ExcelDictConvert;
import io.github.linpeilie.annotations.AutoMapper;
import lombok.Data;

import java.io.Serial;
import java.io.Serializable;
import java.util.Date;



/**
 * 专家库技术资格关系表视图对象 zjk_expert_professional
 *
 * @author zhangzhou
 * @date 2024-11-01
 */
@Data
@ExcelIgnoreUnannotated
@AutoMapper(target = ZjkExpertProfessional.class)
public class ZjkExpertProfessionalVo implements Serializable {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * id
     */
    @ExcelProperty(value = "id")
    private Long id;

    /**
     * 用户 id
     */
    @ExcelProperty(value = "用户 id")
    private Long userId;

    /**
     * 专家 id
     */
    @ExcelProperty(value = "专家 id")
    private Long expertId;

    /**
     * 技术资格
     */
    @ExcelProperty(value = "技术资格")
    private String professional;

    /**
     * 技术资格取得时间
     */
    @ExcelProperty(value = "技术资格取得时间")
    private Date professionalDate;

    /**
     * 租户 id
     */
    @ExcelProperty(value = "租户 id")
    private String tenantId;

    /**
     * 状态
     */
    @ExcelProperty(value = "状态")
    private Integer status;

    /**
     * 备注
     */
    @ExcelProperty(value = "备注")
    private String remark;


}
