package org.dromara.zjk.domain.vo;

import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import com.alibaba.excel.annotation.ExcelProperty;
import io.github.linpeilie.annotations.AutoMapper;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.dromara.common.excel.annotation.ExcelDictFormat;
import org.dromara.common.excel.convert.ExcelDictConvert;
import org.dromara.common.sensitive.annotation.Sensitive;
import org.dromara.common.sensitive.core.SensitiveStrategy;
import org.dromara.zjk.domain.ZjkExpert;
import org.dromara.zjk.domain.ZjkExpertMajor;
import org.dromara.zjk.domain.ZjkExpertProfessional;
import org.dromara.zjk.zwy.annotation.EncryptSensitive;

import java.io.Serial;
import java.io.Serializable;
import java.util.Date;
import java.util.List;


/**
 * expert视图对象 zjk_expert
 *
 * @author wangtong
 * @date 2024-10-24
 */
@Data
@ExcelIgnoreUnannotated
@AutoMapper(target = ZjkExpert.class)
@EqualsAndHashCode
public class ZjkExpertWorkVo implements Serializable {

    @Serial
    private static final long serialVersionUID = 1L;

    private Long expertId;
    private String expertName;

    @EncryptSensitive
    private String contact;
    private String workUnit;
    private String performWorkId;



}
