package org.dromara.zjk.domain.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 积分奖励
 * @TableName zjk_point_reward
 */
@Data
public class ZjkPointRewardVO implements Serializable {
    /**
     * 租户号
     */
    private String id;

    /**
     * 积分奖励名称
     */
    private String rewardName;

    /**
     * 激励类型;字典值reward_type
     */
    private Integer rewardType;

    /**
     * 激励内容
     */
    private String rewardContent;

    /**
     * 激励标的;字典值 积分
     */
    private Integer rewardObj;

    /**
     * 生效符号;><=
     */
    private Integer effectFlag;

    /**
     * 生效标准;临界分值
     */
    private BigDecimal effectStandard;

    /**
     * 激励截至时间
     */
    private Date rewardUntil;

    /**
     * 是否永久;1：永久；0不永久
     */
    private Integer isForever;



    /**
     * 启用标识
     */
    private Integer status;

    /**
     * 创建人
     */
    private String createBy;

    /**
     * 创建时间
     */
    private Date createTime;



    @TableField(exist = false)
    private static final long serialVersionUID = 1L;
}
