package org.dromara.zjk.domain.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import lombok.Data;
import org.dromara.common.mybatis.core.domain.BaseEntity;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 积分记录
 *
 * @TableName zjk_point
 */
@Data
public class ZjkPointVO extends BaseEntity implements Serializable {
    /**
     * 租户号
     */
    private Integer id;

    /**
     * 积分数值
     */
    private BigDecimal points;

    /**
     * 积分事由外键
     */
    private String pointReason;
    /**
     * 用户id
     */
    private Long userId;

    /**
     * 专家id
     */
    private Long expertId;


    @TableField(exist = false)
    private static final long serialVersionUID = 1L;
}
