package org.dromara.zjk.domain.vo;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import com.alibaba.excel.annotation.ExcelProperty;
import io.github.linpeilie.annotations.AutoMapper;
import lombok.Data;
import org.dromara.common.excel.convert.ExcelDictConvert;
import org.dromara.zjk.domain.ZjkExpert;
import org.dromara.zjk.domain.ZjkProductSummarize;

import java.io.Serial;
import java.io.Serializable;
import java.util.Date;
import java.util.List;


/**
 * 项目总结视图对象 zjk_product_summarize
 *
 * @author ygh
 * @date 2024-11-02
 */
@Data
@ExcelIgnoreUnannotated
public class ZjkProductSummarizeExportVo  {


    @ExcelProperty(value = "项目总结编号")
    private Long id;

    /**
     * 总结名称
     */
    @ExcelProperty(value = "总结名称")
    private String productSummarizeName;

    /**
     * 总结类型
     */
    @ExcelProperty(value = "总结类型")
    private String productSummarizeType;

    /**
     * 项目概况
     */
    @ExcelProperty(value = "项目概况")
    private String productGeneral;

    /**
     * 评审范围
     */
    @ExcelProperty(value = "评审范围")
    private String reviewScope;

    /**
     * 评审结论
     */
    @ExcelProperty(value = "评审结论")
    private String reviewConclusion;

    /**
     * 反馈
     */
    @ExcelProperty(value = "反馈")
    private String feedback;

    /**
     * 后续改进措施
     */
    @ExcelProperty(value = "后续改进措施")
    private String subsequent;

    @ExcelProperty(value = "所属项目")
    private String productName;
    /**
     * 状态
     */
    @ExcelIgnore
    private String status;
    /**
     * 状态名称
     */
    @ExcelProperty(value = "状态")
    private String statusName;
}
