package org.dromara.zjk.domain.vo;

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.dromara.zjk.domain.ZjkProductSummarizeLog;
import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import com.alibaba.excel.annotation.ExcelProperty;
import org.dromara.common.excel.annotation.ExcelDictFormat;
import org.dromara.common.excel.convert.ExcelDictConvert;
import io.github.linpeilie.annotations.AutoMapper;
import lombok.Data;
import org.dromara.zjk.domain.ZjkProjectEvaluation;

import java.io.Serial;
import java.io.Serializable;
import java.util.Date;



/**
 * 总结日志表视图对象 zjk_product_summarize_log
 *
 * @author ygh
 * @date 2024-11-04
 */
@Data
@ExcelIgnoreUnannotated
@AutoMapper(target = ZjkProductSummarizeLog.class)
public class ZjkProductSummarizeLogVo implements Serializable {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * $column.columnComment
     */
    @ExcelProperty(value = "${comment}", converter = ExcelDictConvert.class)
    @ExcelDictFormat(readConverterExp = "$column.readConverterExp()")
    private Long id;

    /**
     * 专家抽取id
     */
    @ExcelProperty(value = "专家抽取id", converter = ExcelDictConvert.class)
    @ExcelDictFormat(readConverterExp = "$column.readConverterExp()")
    private Long summarizeId;

    /**
     * 抽取id
     */
    @ExcelProperty(value = "抽取id", converter = ExcelDictConvert.class)
    @ExcelDictFormat(readConverterExp = "$column.readConverterExp()")
    private Long reviewId;

    /**
     * 项目总结名称
     */
    @ExcelProperty(value = "项目总结名称", converter = ExcelDictConvert.class)
    @ExcelDictFormat(readConverterExp = "$column.readConverterExp()")
    private String productSummarizeName;

    /**
     * 项目总结分类
     */
    @ExcelProperty(value = "项目总结分类", converter = ExcelDictConvert.class)
    @ExcelDictFormat(readConverterExp = "$column.readConverterExp()")
    private String productSummarizeType;

    /**
     * 项目概况
     */
    @ExcelProperty(value = "项目概况", converter = ExcelDictConvert.class)
    @ExcelDictFormat(readConverterExp = "$column.readConverterExp()")
    private String productGeneral;

    /**
     * 评审范围
     */
    @ExcelProperty(value = "评审范围", converter = ExcelDictConvert.class)
    @ExcelDictFormat(readConverterExp = "$column.readConverterExp()")
    private String reviewScope;

    /**
     * v评审结论
     */
    @ExcelProperty(value = "评审结论", converter = ExcelDictConvert.class)
    @ExcelDictFormat(readConverterExp = "$column.readConverterExp()")
    private String reviewConclusion;

    /**
     * 反馈
     */
    @ExcelProperty(value = "反馈", converter = ExcelDictConvert.class)
    @ExcelDictFormat(readConverterExp = "$column.readConverterExp()")
    private String feedback;

    /**
     * 后续改进措施
     */
    @ExcelProperty(value = "后续改进措施", converter = ExcelDictConvert.class)
    @ExcelDictFormat(readConverterExp = "$column.readConverterExp()")
    private String subsequent;

    /**
     * 附件
     */
    @ExcelProperty(value = "附件", converter = ExcelDictConvert.class)
    @ExcelDictFormat(readConverterExp = "$column.readConverterExp()")
    private String attachment;

    /**
     * 专家id
     */
    @ExcelProperty(value = "专家id", converter = ExcelDictConvert.class)
    @ExcelDictFormat(readConverterExp = "$column.readConverterExp()")
    private String expertIds;

    /**
     * 状态
     */
    @ExcelProperty(value = "状态", converter = ExcelDictConvert.class)
    @ExcelDictFormat(readConverterExp = "$column.readConverterExp()")
    private String status;

    /**
     * 备注
     */
    @ExcelProperty(value = "备注", converter = ExcelDictConvert.class)
    @ExcelDictFormat(readConverterExp = "$column.readConverterExp()")
    private String remark;

    /**
     * 审核状态
     */
    @ExcelProperty(value = "审核状态", converter = ExcelDictConvert.class)
    @ExcelDictFormat(readConverterExp = "$column.readConverterExp()")
    private String auditStatus;

    /**
     * 审核备注
     */
    @ExcelProperty(value = "审核备注", converter = ExcelDictConvert.class)
    @ExcelDictFormat(readConverterExp = "$column.readConverterExp()")
    private String auditRemark;

    /**
     * 审核人
     */
    @ExcelProperty(value = "审核人", converter = ExcelDictConvert.class)
    @ExcelDictFormat(readConverterExp = "$column.readConverterExp()")
    private Long auditBy;

    /**
     * 审核时间
     */
    @ExcelProperty(value = "审核时间", converter = ExcelDictConvert.class)
    @ExcelDictFormat(readConverterExp = "$column.readConverterExp()")
    private Date auditTime;


    /**
     * 提交人
     */
    private String  subBy;

    /**
     * 提交时间
     */
    private Date subTime;

    private Long productId;

    private String productName;

    private String reviewSn;

    private String reviewTime;

    /*
     * 是否评价
     * */
    private Integer isEvaluate;


    private ZjkProjectEvaluation zjkProjectEvaluation;
}
