package org.dromara.zjk.domain.vo;

import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import io.github.linpeilie.annotations.AutoMapper;
import lombok.Data;
import org.dromara.zjk.domain.ZjkReviewPhase;

import java.io.Serial;
import java.io.Serializable;
import java.util.Date;
import java.util.List;


/**
 * 抽取条件视图对象 zjk_review_phase
 *
 * @author ygh
 * @date 2024-11-01
 */
@Data
@ExcelIgnoreUnannotated
@AutoMapper(target = ZjkReviewPhase.class)
public class ZjkReviewPhaseVo implements Serializable {

    @Serial
    private static final long serialVersionUID = 1L;


    private Long id;

    /**
     * 租户id
     */

    private String tenantId;

    /**
     * 评审阶段
     */

    private String reviewSn;

    /**
     *评审时间
     */

    private Date reviewTime;

    /**
     *评审地点
     */

    private String reviewPlace;

    /**
     *计划抽取人数
     */

    private Integer plannedIntake;

    /**
     *抽取方式
     */

    private String extractionMode;

    /**
     *抽取限制
     */

    private String extractioRestriction;

    /**
     *回避专家
     */

    private String avoidanceExpert;

    /**
     *回避单位
     */

    private String avoidanceUnit;

    /*
     * 项目id
     * */
    private Long itemId;

    private String designatedNumber;

    private String area;

    private Integer effective;

    private Long parentId;

    //抽取地域
    private String extractArea;

    /**
     *
     */
    private Long revision;

    private Long itemExtreationId;

    //数据来源  1：补抽
    private Integer source;

    //是否总结 0未总结  1总结
    private Long isSummarize;
    /**
     * 专家确认截至时间
     */
    private Date noticeTime;
    /**
     * 阶段专家
     */
    private List<ZjkExpertVo> zjkExpertVoList;
}
