package org.dromara.zjk.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

@Getter
@AllArgsConstructor
public enum BusinessTypeEnum {


    EXPERT_INFO_CHANGE("1","专家信息变更"),


    PROJECT_INFO_CHANGE("2","项目信息变更");
    /**
     * 状态
     */
    private final String code;

    /**
     * 描述
     */
    private final String desc;

    public static BusinessTypeEnum getByCode(String code) {
        for (BusinessTypeEnum businessTypeEnum : BusinessTypeEnum.values()) {
            if (businessTypeEnum.getCode().equals( code)) {
                return businessTypeEnum;
            }
        }
        return null; // 找不到对应 code 的枚举值时返回 null
    }
}
