package org.dromara.zjk.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 *请假枚举类
 */
@Getter
@AllArgsConstructor
public enum LeaveStatusEnum {
    /**
     * 状态: 0：待审批 1：通过 2：驳回
     */
    //待审批
    APPROVAL("0","待审批"),
    //正常
    SUCCESS("1","审批通过"),
    //拒绝
    ERROR("2","审批驳回");


    /**
     * 状态
     */
    private final String code;

    /**
     * 描述
     */
    private final String desc;

    public String getCodeAsString() {
        return String.valueOf(this.code);
    }
}
