package org.dromara.zjk.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 积分趋势分析
 */
@Getter
@AllArgsConstructor
public enum PointTrendEnum {

    //近七天
    SEVEN_DAY("seven", 7),
    //近一月
    SUCCESS("month", 30),
    //近半年
    ERROR("halfYear", 182);


    /**
     * 状态
     */
    private final String code;

    /**
     * 描述
     */
    private final int day;

    public static int getDayByCode(String key) {
        for (PointTrendEnum code : PointTrendEnum.values()) {
            if (code.getCode().equals(key)) {
                return code.getDay();
            }
        }
        return 0; // 或者抛出一个异常，如果key不存在
    }

}
