package org.dromara.zjk.enums;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.Getter;
import lombok.NoArgsConstructor;

@Getter
@AllArgsConstructor
public enum productSummarizeTypeEnum {
    PROJECT_APPROVAL("1","立项总结"),
    CALL_BIDS("2","立项总结"),
    PRELIMINARY_ACCEPTANCE("3","立项总结"),
    FINAL_ACCEPTANCE("4","立项总结");

    /**
     * 状态
     */
    private final String code;

    /**
     * 描述
     */
    private final String desc;

    public static ReviewSnEnum getByCode(String code) {
        for (ReviewSnEnum status : ReviewSnEnum.values()) {
            if (status.getCode().equals( code)) {
                return status;
            }
        }
        return null; // 找不到对应 code 的枚举值时返回 null
    }
}
