package org.dromara.zjk.event.custom;

import cn.hutool.json.JSONUtil;
import lombok.extern.slf4j.Slf4j;
import org.dromara.zjk.domain.dto.CreditInfoDto;
import org.dromara.zjk.domain.dto.PointInfoDto;
import org.dromara.zjk.event.CreditAddEvent;
import org.dromara.zjk.event.PointAddEvent;
import org.dromara.zjk.service.IZjkCreditService;
import org.dromara.zjk.service.IZjkCreditUserService;
import org.dromara.zjk.service.ZjkPointUserService;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

/**
 * @author : yanguohua
 * @version : 1.0
 * @date : 2024/11/7 16:24
 */
@Component
@Slf4j
public class AddCreditListener implements ApplicationListener<CreditAddEvent> {
    @Resource
    private IZjkCreditUserService zjkCreditUserService;
    @Override
    public void onApplicationEvent(CreditAddEvent event) {
        CreditInfoDto creditInfoDto = event.getCreditInfoDto();
        savePointInfo(creditInfoDto);

    }
    /**
     * 保存系统日志记录
     */
    @EventListener
    public void savePointInfo(CreditInfoDto creditInfoDto) {
        zjkCreditUserService.saveCreditUser(creditInfoDto);
        log.info("信用变更：" + JSONUtil.toJsonStr(creditInfoDto));
    }
}
