package org.dromara.zjk.event.custom;

import cn.hutool.json.JSONUtil;
import lombok.extern.slf4j.Slf4j;
import org.dromara.zjk.domain.dto.PointInfoDto;
import org.dromara.zjk.event.PointAddEvent;
import org.dromara.zjk.service.ZjkPointUserService;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

/**
 * @author : yanguohua
 * @version : 1.0
 * @date : 2024/11/7 16:24
 */
@Component
@Slf4j
public class AddPointListener implements ApplicationListener<PointAddEvent> {
    @Resource
    private ZjkPointUserService zjkPointUserService;
    @Override
    public void onApplicationEvent(PointAddEvent event) {
        PointInfoDto pointInfoDto = event.getPointInfoDto();
        savePointInfo(pointInfoDto);

    }
    /**
     * 保存系统日志记录
     */
    @EventListener
    public void savePointInfo(PointInfoDto pointInfoEvent) {
        zjkPointUserService.savePointInfo(pointInfoEvent);
        log.info("积分入库：" + JSONUtil.toJsonStr(pointInfoEvent));
    }
}
