package org.dromara.zjk.expert.expertPaper.domain;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.dromara.common.tenant.core.TenantEntity;
import org.dromara.zjk.annotation.PropertyMsg;

import java.io.Serial;

/**
 * 专家论文信息对象 zjk_expert_paper
 *
 * @author zhangzhou
 * @date 2024-11-10
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("zjk_expert_paper")
public class ZjkExpertPaper extends TenantEntity {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * id
     */
    private Long id;

    /**
     * 专家 id
     */
    private Long expertId;

    /**
     * 论文名称
     */
    @PropertyMsg(propertyName = "论文名称")
    private String paperName;

    /**
     * 期刊号
     */
    @PropertyMsg(propertyName = "期刊号")
    private String periodicalNumber;

    /**
     * 论文附件
     */
    @PropertyMsg(propertyName = "论文附件")
    private String paperPath;

    /**
     * 逻辑删除
     */
    private Long delFlag;
    /**
     * 原名
     */
    @TableField(exist = false)
    private String originalName;

    /**
     * 文件后缀名
     */
    @TableField(exist = false)
    private String fileSuffix;
    private Long productId;

    /**
     * url
     */
    @TableField(exist = false)
    private String url;
    private String reviewSn;
}
